/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.soo;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkEvent;
import com.ibm.hwmca.fw.util.WorkListener;
import com.ibm.hwmca.fw.util.WorkPerformer;
import com.ibm.hwmca.fw.util.WorkThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class StreamProxy
implements WorkListener,
WorkPerformer {
    private Socket s1;
    private Socket s2;
    private static final String TRACE_MASKT = "XSOOPRXT";
    private static final String TRACE_MASKF = "XSOOPRXF";
    private static final String TRACE_MASKD = "XSOOPRXD";

    public StreamProxy(Socket socket1, Socket socket2) {
        this.s1 = socket1;
        this.s2 = socket2;
    }

    public void start() {
        Trace.trace(TRACE_MASKT, "-> start");
        WorkThread.invokeAsync(this, this, new SocketPair(this.s1, this.s2), "StreamProxy from " + this.s1.getInetAddress().getHostAddress() + " to " + this.s2.getInetAddress().getHostAddress());
        WorkThread.invokeAsync(this, this, new SocketPair(this.s2, this.s1), "StreamProxy from " + this.s2.getInetAddress().getHostAddress() + " to " + this.s1.getInetAddress().getHostAddress());
        Trace.trace(TRACE_MASKT, "<- start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object performWork(Object parms) throws Throwable {
        block15: {
            Trace.trace(TRACE_MASKT, "-> performWork");
            SocketPair socketPair = (SocketPair)parms;
            InputStream inputStream = socketPair.getInputSocket().getInputStream();
            OutputStream outputStream = socketPair.getOutputSocket().getOutputStream();
            byte[] buffer = new byte[4096];
            Trace.trace(TRACE_MASKF, "About to issue first read on input socket");
            int count = inputStream.read(buffer);
            Trace.trace(TRACE_MASKD, "read count=" + count);
            while (count != -1) {
                outputStream.write(buffer, 0, count);
                count = inputStream.read(buffer);
                Trace.trace(TRACE_MASKD, "read count=" + count);
            }
            Trace.trace(TRACE_MASKD, "Reached end-of-file on input stream");
            Object var8_8 = null;
            Trace.trace(TRACE_MASKF, "Closing input socket");
            try {
                socketPair.getInputSocket().close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            Trace.trace(TRACE_MASKF, "Closing output socket");
            try {
                socketPair.getOutputSocket().close();
            }
            catch (IOException e2) {}
            break block15;
            {
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Caught an Exception: " + e);
                    Object var8_9 = null;
                    Trace.trace(TRACE_MASKF, "Closing input socket");
                    try {
                        socketPair.getInputSocket().close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    Trace.trace(TRACE_MASKF, "Closing output socket");
                    try {
                        socketPair.getOutputSocket().close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                Trace.trace(TRACE_MASKF, "Closing input socket");
                try {
                    socketPair.getInputSocket().close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                Trace.trace(TRACE_MASKF, "Closing output socket");
                try {
                    socketPair.getOutputSocket().close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "<- performWork");
        return null;
    }

    public void workCompleted(WorkEvent ev) {
        Trace.trace(TRACE_MASKT, "<> workCompleted; " + (ev.hasException() ? "an exception occurred: " + ev.getException().getMessage() : "no exception"));
    }

    private static class SocketPair {
        private Socket inputSocket;
        private Socket outputSocket;

        SocketPair(Socket in, Socket out) {
            this.inputSocket = in;
            this.outputSocket = out;
        }

        Socket getInputSocket() {
            return this.inputSocket;
        }

        Socket getOutputSocket() {
            return this.outputSocket;
        }
    }
}

